<?php
/**
 * Authentication Language Lines
 * The following language lines are used during authentication for various
 * messages that we need to display to the user.
 */
return [

    'failed' => 'Estas credenciales no concuerdan con nuestros registros.',
    'throttle' => 'Demasiados intentos fallidos de inicio de sesión. Por favor intente nuevamente en :seconds segundos.',

    // Login & Register
    'sign_up' => 'Registrarse',
    'log_in' => 'Iniciar sesión',
    'log_in_with' => 'Acceder con :socialDriver',
    'sign_up_with' => 'Registrarse con :socialDriver',
    'logout' => 'Salir',

    'name' => 'Nombre',
    'username' => 'Nombre de usuario',
    'email' => 'Correo electrónico',
    'password' => 'Contraseña',
    'password_confirm' => 'Confirmar contraseña',
    'password_hint' => 'Debe contener al menos 8 caracteres',
    'forgot_password' => '¿Olvidó la contraseña?',
    'remember_me' => 'Recordarme',
    'ldap_email_hint' => 'Por favor introduzca un correo electrónico para utilizar con esta cuenta.',
    'create_account' => 'Crear una cuenta',
    'already_have_account' => '¿Ya tiene una cuenta?',
    'dont_have_account' => '¿No tiene una cuenta?',
    'social_login' => 'Acceso con cuenta Social',
    'social_registration' => 'Registro con cuenta Social',
    'social_registration_text' => 'Registrar y entrar utilizando otro servicio.',

    'register_thanks' => '¡Gracias por registrarse!',
    'register_confirm' => 'Por favor verifique su correo electrónico y presione en el botón de confirmación enviado para acceder a :appName.',
    'registrations_disabled' => 'Los registros están deshabilitados actualmente',
    'registration_email_domain_invalid' => 'Este dominio de correo electrónico no tiene acceso a esta aplicación',
    'register_success' => '¡Gracias por registrarse! Ahora se encuentra registrado y ha accedido a la aplicación.',

    // Login auto-initiation
    'auto_init_starting' => 'Intentando iniciar sesión',
    'auto_init_starting_desc' => 'Estamos contactando con su sistema de autenticación para comenzar el proceso de inicio de sesión. Si no hay progreso después de 5 segundos puede intentar hacer clic en el enlace de abajo.',
    'auto_init_start_link' => 'Continuar con la autenticación',

    // Password Reset
    'reset_password' => 'Restablecer la contraseña',
    'reset_password_send_instructions' => 'Introduzca su correo electrónico a continuación y se le enviará un correo electrónico con un enlace para la restauración',
    'reset_password_send_button' => 'Enviar enlace de restauración',
    'reset_password_sent' => 'Si la dirección de correo electrónico :email existe en el sistema, se enviará un enlace para restablecer la contraseña.',
    'reset_password_success' => 'Su contraseña se restableció con éxito.',
    'email_reset_subject' => 'Restauración de la contraseña de para la aplicación :appName',
    'email_reset_text' => 'Ud. esta recibiendo este correo electrónico debido a que recibimos una solicitud de restauración de la contraseña de su cuenta.',
    'email_reset_not_requested' => 'Si ud. no solicitó un cambio de contraseña, no se requiere ninguna acción.',

    // Email Confirmation
    'email_confirm_subject' => 'Confirme su correo electrónico en :appName',
    'email_confirm_greeting' => '¡Gracias por unirse a :appName!',
    'email_confirm_text' => 'Por favor confirme su dirección de correo electrónico presionando en el siguiente botón:',
    'email_confirm_action' => 'Confirmar correo electrónico',
    'email_confirm_send_error' => 'Se pidió confirmación de correo electrónico pero el sistema no pudo enviar el correo electrónico. Contacte al administrador para asegurarse que el correo electrónico está configurado correctamente.',
    'email_confirm_success' => '¡Su correo electrónico ha sido confirmado! Ahora debería poder iniciar sesión usando esta dirección de correo electrónico.',
    'email_confirm_resent' => 'Correo electrónico de confirmación reenviado, Por favor verifique su bandeja de entrada.',
    'email_confirm_thanks' => '¡Gracias por confirmar!',
    'email_confirm_thanks_desc' => 'Por favor, espere un momento mientras se gestiona su confirmación. Si no se lo redirige después de 3 segundos, pulse el enlace "Continuar" para seguir.',

    'email_not_confirmed' => 'Dirección de correo electrónico no confirmada',
    'email_not_confirmed_text' => 'Su cuenta de correo electrónico todavía no ha sido confirmada.',
    'email_not_confirmed_click_link' => 'Por favor verifique el correo electrónico con el enlace de confirmación que fue enviado luego de registrarse.',
    'email_not_confirmed_resend' => 'Si no puede encontrar el correo electrónico, puede solicitar el renvío del correo electrónico de confirmación rellenando el formulario a continuación.',
    'email_not_confirmed_resend_button' => 'Reenviar correo electrónico de confirmación',

    // User Invite
    'user_invite_email_subject' => 'Lo invitaron a unirse a :appName!',
    'user_invite_email_greeting' => 'Se creó una cuenta para usted en :appName.',
    'user_invite_email_text' => 'Presione el botón de abajo para establecer una contraseña y tener acceso access:',
    'user_invite_email_action' => 'Establecer la contraseña de la cuenta',
    'user_invite_page_welcome' => 'Bienvenido a :appName!',
    'user_invite_page_text' => 'Para finalizar la cuenta y tener acceso debe establcer una contraseña que utilizará para ingresar a :appName en visitas futuras.',
    'user_invite_page_confirm_button' => 'Confirmar Contraseña',
    'user_invite_success_login' => 'Contraseña guardada, ¡ahora debería ser capaz de iniciar sesión usando su contraseña establecida para acceder a :appName!',

    // Multi-factor Authentication
    'mfa_setup' => 'Configurar autenticación de múltiples factores',
    'mfa_setup_desc' => 'Configure la autenticación de múltiples factores como una capa extra de seguridad para su cuenta de usuario.',
    'mfa_setup_configured' => 'Ya está configurado',
    'mfa_setup_reconfigure' => 'Reconfigurar',
    'mfa_setup_remove_confirmation' => '¿Está seguro que desea eliminar este método de autenticación de múltiples factores?',
    'mfa_setup_action' => 'Configuración',
    'mfa_backup_codes_usage_limit_warning' => 'Quedan menos de 5 códigos de respaldo, Por favor, genere y guarde un nuevo conjunto antes de que se quede sin códigos para evitar que se bloquee su cuenta.',
    'mfa_option_totp_title' => 'Aplicación móvil',
    'mfa_option_totp_desc' => 'Para utilizar la autenticación en dos pasos necesitará una aplicación móvil que soporte TOTP como Google Authenticator, Authy o Microsoft Authenticator.',
    'mfa_option_backup_codes_title' => 'Códigos de Respaldo',
    'mfa_option_backup_codes_desc' => 'Genera un conjunto de códigos de respaldo de un único uso que ingresará al iniciar sesión para verificar su identidad. Asegúrese de guardarlos en un lugar seguro.',
    'mfa_gen_confirm_and_enable' => 'Confirmar y Activar',
    'mfa_gen_backup_codes_title' => 'Configuración de Códigos de Respaldo',
    'mfa_gen_backup_codes_desc' => 'Guarde la siguiente lista de códigos en un lugar seguro. Al acceder al sistema podrá usar uno de los códigos como un segundo mecanismo de autenticación.',
    'mfa_gen_backup_codes_download' => 'Descargar Códigos',
    'mfa_gen_backup_codes_usage_warning' => 'Cada código puede utilizarse sólo una vez',
    'mfa_gen_totp_title' => 'Configuración de Aplicación móvil',
    'mfa_gen_totp_desc' => 'Para utilizar la autenticación en dos pasos necesitará una aplicación móvil que soporte TOTP como Google Authenticator, Authy o Microsoft Authenticator.',
    'mfa_gen_totp_scan' => 'Escanea el código QR mostrado a continuación usando tu aplicación de autenticación preferida para empezar.',
    'mfa_gen_totp_verify_setup' => 'Verificar Configuración',
    'mfa_gen_totp_verify_setup_desc' => 'Verifica que todo está funcionando introduciendo un código, generado en tu aplicación de autenticación, en el campo de texto a continuación:',
    'mfa_gen_totp_provide_code_here' => 'Introduce aquí tu código generado por la aplicación',
    'mfa_verify_access' => 'Verificar Acceso',
    'mfa_verify_access_desc' => 'Su cuenta de usuario requiere que confirme su identidad a través de un nivel adicional de verificación antes de que se le conceda el acceso. Verifique su identidad usando uno de los métodos configurados para continuar.',
    'mfa_verify_no_methods' => 'No hay Métodos Configurados',
    'mfa_verify_no_methods_desc' => 'No se han encontrado métodos de autenticación de múltiples factores para su cuenta. Tendrá que configurar al menos un método antes de obtener acceso.',
    'mfa_verify_use_totp' => 'Verificar usando una aplicación móvil',
    'mfa_verify_use_backup_codes' => 'Verificar usando un código de respaldo',
    'mfa_verify_backup_code' => 'Código de Respaldo',
    'mfa_verify_backup_code_desc' => 'Introduzca uno de sus códigos de respaldo restantes a continuación:',
    'mfa_verify_backup_code_enter_here' => 'Introduzca el código de respaldo aquí',
    'mfa_verify_totp_desc' => 'A continuación, introduzca el código generado con su aplicación móvil:',
    'mfa_setup_login_notification' => 'Método de dos factores configurado. Por favor, inicie sesión nuevamente utilizando el método configurado.',
];
