<?php
/**
 * Settings text strings
 * Contains all text strings used in the general settings sections of BookStack
 * including users and roles.
 */
return [

    // Common Messages
    'settings' => '設定',
    'settings_save' => '儲存設定',
    'system_version' => '系統版本',
    'categories' => '分類',

    // App Settings
    'app_customization' => '自訂',
    'app_features_security' => '功能與安全',
    'app_name' => '應用程式名稱',
    'app_name_desc' => '此名稱會在網頁頂端與任何系統傳送的電子郵件中出現。',
    'app_name_header' => '在網頁頂端顯示名稱',
    'app_public_access' => '公開存取',
    'app_public_access_desc' => '啟用此選項將會允許未登入的訪客存取您 BookStack 站台中的內容。',
    'app_public_access_desc_guest' => '可以透過「訪客」使用者控制公開訪客的存取。',
    'app_public_access_toggle' => '允許公開存取',
    'app_public_viewing' => '允許公開檢視？',
    'app_secure_images' => '更高安全性的圖片上傳',
    'app_secure_images_toggle' => '啟用更高安全性的圖片上傳',
    'app_secure_images_desc' => '因為效能因素，所有圖片都是公開的。此選項會在圖片的網址前加入一串隨機且難以猜測的字串。確保未啟用目錄索引，讓直接進入變得更困難。',
    'app_default_editor' => '預設頁面編輯器',
    'app_default_editor_desc' => '選擇編輯頁面時預設使用的編輯器，這項設定值可被頁面的權限覆蓋',
    'app_custom_html' => '自訂 HTML 標題內容',
    'app_custom_html_desc' => '此處加入的任何內容都將插入到每個頁面的 <head> 部分的底部，這對於覆蓋樣式或加入分析程式碼很方便。',
    'app_custom_html_disabled_notice' => '在此設定頁面上停用了自訂 HTML 標題內容，以確保任何重大變更都能被還原。',
    'app_logo' => '應用程式圖示',
    'app_logo_desc' => '這個設定會被使用在應用程式標題欄等區域；圖片的高度應為 86 像素，大型圖片將會按比例縮小。',
    'app_icon' => '應用程式圖示',
    'app_icon_desc' => '這個圖示將顯示在瀏覽器分頁以及捷徑，應為 256 像素的的正方形 PNG 圖片',
    'app_homepage' => '應用程式首頁',
    'app_homepage_desc' => '選取要作為首頁的頁面，這將會取代預設首頁。選定頁面的頁面權限將會被忽略。',
    'app_homepage_select' => '選取頁面',
    'app_footer_links' => '頁面註腳連結',
    'app_footer_links_desc' => '新增連結以在網站註腳顯示。這些將會顯示在大多數頁面的底部，包含那些不需要登入的頁面。您可以使用 "trans::<key>" 標籤來使用系統定義的翻譯。舉例來說：使用 "trans::common.privacy_policy" 將會提供已翻譯的文字「隱私權政策」，以及 "trans::common.terms_of_service" 將會提供已翻譯的文字「服務條款」。',
    'app_footer_links_label' => '連結標籤',
    'app_footer_links_url' => '連結網址',
    'app_footer_links_add' => '新增註腳連結',
    'app_disable_comments' => '停用評論',
    'app_disable_comments_toggle' => '停用評論',
    'app_disable_comments_desc' => '在應用程式的所有頁面停用評論。<br>既有的評論將不會顯示。',

    // Color settings
    'color_scheme' => '應用程式配色',
    'color_scheme_desc' => '設定使用者頁面欲使用的顏色。可分別針對淺色模式與暗色模式設定顏色，以確保容易閱讀',
    'ui_colors_desc' => '設定頁面主要色彩以及頁面連結預設顏色。主要色彩用於標題橫幅、按鈕以及主要操作界面，頁面連結顏色，主要用於主頁面、編輯頁面中的文字連結、操作按鈕。',
    'app_color' => '主要顏色',
    'link_color' => '連結預設顏色',
    'content_colors_desc' => '設定頁面層次結構中的元素顏色；為了提高可讀性，建議選擇亮度與預設顏色相似的顏色。',
    'bookshelf_color' => '書架顔色',
    'book_color' => '書本顔色',
    'chapter_color' => '章節顔色',
    'page_color' => '頁面顔色',
    'page_draft_color' => '頁面草稿顏色',

    // Registration Settings
    'reg_settings' => '註冊',
    'reg_enable' => '啟用註冊',
    'reg_enable_toggle' => '啟用註冊',
    'reg_enable_desc' => '啟用註冊後，使用者將可以自行註冊為應用程式的使用者。註冊後，他們將會得到一個預設的使用者角色。',
    'reg_default_role' => '註冊後的預設使用者角色',
    'reg_enable_external_warning' => '當外部 LDAP 或 SAML 身份驗證啟用時，將會忽略上述選項。如果外部身份驗證成功，將會自動在本系統建立使用者帳號。',
    'reg_email_confirmation' => '電子郵件驗證',
    'reg_email_confirmation_toggle' => '需要電子郵件驗證',
    'reg_confirm_email_desc' => '如果使用網域限制，則需要電子郵件驗證，且此選項將被忽略。',
    'reg_confirm_restrict_domain' => '網域限制',
    'reg_confirm_restrict_domain_desc' => '輸入您想要限制註冊的電子郵件網域列表，以英文逗號分隔。在可以與應用程式互動前，使用者將會收到電子郵件以確認他們的電子郵件地址。<br>注意，使用者可以在註冊成功後變更他們的電子郵件地址。',
    'reg_confirm_restrict_domain_placeholder' => '尚未設定限制',

    // Sorting Settings
    'sorting' => '排序',
    'sorting_book_default' => '預設書籍排序',
    'sorting_book_default_desc' => '選取要套用至新書籍的預設排序規則。這不會影響現有書籍，並可按書籍覆寫。',
    'sorting_rules' => '排序規則',
    'sorting_rules_desc' => '這些是預先定義的排序作業，可套用於系統中的內容。',
    'sort_rule_assigned_to_x_books' => '指定給 :count 本書',
    'sort_rule_create' => '建立排序規則',
    'sort_rule_edit' => '編輯排序規則',
    'sort_rule_delete' => '刪除排序規則',
    'sort_rule_delete_desc' => '從系統移除此排序規則。使用此排序的書籍將會還原為手動排序。',
    'sort_rule_delete_warn_books' => '此排序規則目前用於 :count 本書。您確定您想要刪除嗎？',
    'sort_rule_delete_warn_default' => '此排序規則目前為書籍的預設值。您確定您想要刪除嗎？',
    'sort_rule_details' => '排序規則詳細資訊',
    'sort_rule_details_desc' => '設定此排序規則的名稱，當使用者選取排序時，該名稱將會出現在清單中。',
    'sort_rule_operations' => '排序選項',
    'sort_rule_operations_desc' => '設定要執行的排序動作，方法是從可用的操作清單中移動它們。使用時，操作將依從上到下的順序套用。儲存時，在此處所做的任何變更都會套用至所有指定的書籍。',
    'sort_rule_available_operations' => '可用操作',
    'sort_rule_available_operations_empty' => '無剩餘操作',
    'sort_rule_configured_operations' => '已設定的操作',
    'sort_rule_configured_operations_empty' => '從「可用操作」清單中拖曳/新增操作',
    'sort_rule_op_asc' => '（遞增）',
    'sort_rule_op_desc' => '（遞減）',
    'sort_rule_op_name' => '名稱 - 按字母順序排列',
    'sort_rule_op_name_numeric' => '名稱 - 數字',
    'sort_rule_op_created_date' => '建立日期',
    'sort_rule_op_updated_date' => '更新日期',
    'sort_rule_op_chapters_first' => '第一章',
    'sort_rule_op_chapters_last' => '最後一章',

    // Maintenance settings
    'maint' => '維護',
    'maint_image_cleanup' => '清理圖片',
    'maint_image_cleanup_desc' => '掃描頁面與修訂版本內容來檢查目前使用了哪些圖片，而哪些圖片又是多餘的。請確保您在執行這個動作前建立了完整的資料庫與映像檔備份。',
    'maint_delete_images_only_in_revisions' => '也刪除僅存在於舊的頁面修訂版本中存在的圖片',
    'maint_image_cleanup_run' => '執行清理',
    'maint_image_cleanup_warning' => '發現了 :count 張可能未使用的圖片。您確定要刪除這些圖片嗎？',
    'maint_image_cleanup_success' => '找到並刪除了 :count 張可能未使用的圖片！',
    'maint_image_cleanup_nothing_found' => '找不到未使用的圖片，未刪除任何檔案！',
    'maint_send_test_email' => '傳送測試電子郵件',
    'maint_send_test_email_desc' => '這會將測試電子郵件傳送到您的個人資料中指定的電子郵件地址。',
    'maint_send_test_email_run' => '傳送測試郵件',
    'maint_send_test_email_success' => '電子郵件已傳送到 :address',
    'maint_send_test_email_mail_subject' => '測試郵件',
    'maint_send_test_email_mail_greeting' => '電子郵件傳遞似乎有效！',
    'maint_send_test_email_mail_text' => '恭喜！您收到這封電子郵件通知時，代表您的電子郵件設定已正確設定。',
    'maint_recycle_bin_desc' => '刪除的書架、書本、章節與頁面將會被傳送到回收桶，這樣仍可以還原或永久刪除。回收桶中較舊的項目可能會在一段時間後自動移除，取決於您的系統設定。',
    'maint_recycle_bin_open' => '開啟回收桶',
    'maint_regen_references' => '重新生成引用',
    'maint_regen_references_desc' => '此操作將重建數據庫中的跨項目引用索引。這通常是自動處理的，但可能有助於索引舊內容或通過非官方方法添加的內容。',
    'maint_regen_references_success' => '引用索引已重新生成！',
    'maint_timeout_command_note' => '備註：這項操作需要較長的時間，可能導致多數的網路環境發生連線逾時的問題。若有需要，可以透過終端機指令來替代。',

    // Recycle Bin
    'recycle_bin' => '資源回收桶',
    'recycle_bin_desc' => '在這裡，您可以還原已刪除的項目，或是選擇將其從系統中永久移除。與系統中套用了權限過濾條件類似的活動列表不同的是，此列表並未過濾。',
    'recycle_bin_deleted_item' => '已刪除項目',
    'recycle_bin_deleted_parent' => '上層',
    'recycle_bin_deleted_by' => '刪除由',
    'recycle_bin_deleted_at' => '刪除時間',
    'recycle_bin_permanently_delete' => '永久刪除',
    'recycle_bin_restore' => '還原',
    'recycle_bin_contents_empty' => '回收桶目前是空的',
    'recycle_bin_empty' => '清空回收桶',
    'recycle_bin_empty_confirm' => '這將會永久破壞回收桶中的所有項目，包括每個項目中包含的內容。您確定您想要清空回收桶嗎？',
    'recycle_bin_destroy_confirm' => '此操作將從系統中永久刪除此項目以及下面列出的所有子元素，並且您將無法還原此內容。您確定要永久刪除該項目嗎？',
    'recycle_bin_destroy_list' => '要被銷毀的項目',
    'recycle_bin_restore_list' => '要被還原的項目',
    'recycle_bin_restore_confirm' => '此動作將會還原已被刪除的項目（包含任何下層元素）到其原始位置。如果原始位置已被刪除，且目前位於垃圾桶裡，那麼上層項目也需要被還原。',
    'recycle_bin_restore_deleted_parent' => '此項目的上層項目也已被刪除。因此將會保持被刪除的狀態，直到上層項目也被還原。',
    'recycle_bin_restore_parent' => '還原上層',
    'recycle_bin_destroy_notification' => '已從回收桶刪除共 :count 個項目。',
    'recycle_bin_restore_notification' => '已從回收桶還原共 :count 個項目。',

    // Audit Log
    'audit' => '稽核記錄',
    'audit_desc' => '此稽核日誌會顯示被系統追蹤的活動列表。與系統中套用了權限過濾條件類似的活動列表不同的是，此列表並未過濾。',
    'audit_event_filter' => '活動過濾條件',
    'audit_event_filter_no_filter' => '無過濾條件',
    'audit_deleted_item' => '已刪除的項目',
    'audit_deleted_item_name' => '名稱：:name',
    'audit_table_user' => '使用者',
    'audit_table_event' => '活動',
    'audit_table_related' => '相關的項目或詳細資訊',
    'audit_table_ip' => 'IP 位址',
    'audit_table_date' => '活動日期',
    'audit_date_from' => '日期範圍，從',
    'audit_date_to' => '日期範圍，到',

    // Role Settings
    'roles' => '角色',
    'role_user_roles' => '使用者角色',
    'roles_index_desc' => '「角色」用於將系統權限套用至使用者群組。當使用者擁有多角色時，
使用者會自動繼承角色中的所有系統權限',
    'roles_x_users_assigned' => ':count 位用戶已分配|:count 位用戶已分配',
    'roles_x_permissions_provided' => ':count 個權限|:count 個權限',
    'roles_assigned_users' => '已分配用戶',
    'roles_permissions_provided' => '已提供權限',
    'role_create' => '建立新角色',
    'role_delete' => '刪除角色',
    'role_delete_confirm' => '這將會刪除名為「:roleName」的角色.',
    'role_delete_users_assigned' => '有 :userCount 位使用者屬於此角色。如果您想將此角色中的使用者遷移，請在下面選擇一個新角色。',
    'role_delete_no_migration' => "不要遷移使用者",
    'role_delete_sure' => '您確定要刪除此角色？',
    'role_edit' => '編輯角色',
    'role_details' => '角色詳細資訊',
    'role_name' => '角色名稱',
    'role_desc' => '角色簡短說明',
    'role_mfa_enforced' => '多重身分驗證',
    'role_external_auth_id' => '外部身份驗證 ID',
    'role_system' => '系統權限',
    'role_manage_users' => '管理使用者',
    'role_manage_roles' => '管理角色與角色權限',
    'role_manage_entity_permissions' => '管理所有書本、章節與頁面的權限',
    'role_manage_own_entity_permissions' => '管理自己的書本、章節與頁面的權限',
    'role_manage_page_templates' => '管理頁面範本',
    'role_access_api' => '存取系統 API',
    'role_manage_settings' => '管理應用程式設定',
    'role_export_content' => '匯出內容',
    'role_import_content' => '匯入內容',
    'role_editor_change' => '重設頁面編輯器',
    'role_notifications' => '管理和接收通知',
    'role_asset' => '資源權限',
    'roles_system_warning' => '請注意，有上述三項權限中的任一項的使用者都可以更改自己或系統中其他人的權限。有這些權限的角色只應分配給受信任的使用者。',
    'role_asset_desc' => '對系統內資源的預設權限將由這裡的權限控制。若有單獨設定在書本、章節和頁面上的權限，將會覆寫這裡的權限設定。',
    'role_asset_admins' => '管理員會自動取得對所有內容的存取權，但這些選項可能會顯示或隱藏使用者介面的選項。',
    'role_asset_image_view_note' => '這與圖像管理器中的可見性有關。已經上傳的圖片的實際訪問取決於系統圖像存儲選項。',
    'role_all' => '全部',
    'role_own' => '擁有',
    'role_controlled_by_asset' => '依據隸屬的資源來決定',
    'role_save' => '儲存角色',
    'role_users' => '屬於此角色的使用者',
    'role_users_none' => '目前沒有使用者被分配到此角色',

    // Users
    'users' => '使用者',
    'users_index_desc' => '在系統中創建和管理使用者帳號。使用者帳號用於紀錄登入與編輯活動；訪問權限則由使用者所歸屬的角色群組決定，但使用者是否具備內容的所有權以及其他因素，都可能會影響到存取權限。',
    'user_profile' => '使用者個人資料',
    'users_add_new' => '新增使用者',
    'users_search' => '搜尋使用者',
    'users_latest_activity' => '最新活動',
    'users_details' => '使用者詳細資訊',
    'users_details_desc' => '為此使用者設定顯示名稱與電子郵件地址。電子郵件地址將用於登入應用程式。',
    'users_details_desc_no_email' => '為此使用者設定顯示名稱，這樣其他人才能認出該使用者。',
    'users_role' => '使用者角色',
    'users_role_desc' => '選取要分配的此使用者的角色。若使用者被分配到多個角色，則這些角色的權限將會堆疊，使用者將會取得被分配角色的所有功能。',
    'users_password' => '使用者密碼',
    'users_password_desc' => '設定用於登入應用程式的密碼。密碼必須至少 8 個字元長。',
    'users_send_invite_text' => '您可以選擇向此使用者傳送邀請電子郵件，讓他們可以設定自己的密碼，您也可以自行設定他們的密碼。',
    'users_send_invite_option' => '傳送邀請電子郵件給使用者',
    'users_external_auth_id' => '外部身份驗證 ID',
    'users_external_auth_id_desc' => '使用外部驗證系統時 (如 SAML2、OIDC、LDAP)，將使這個帳號與驗證系統帳號連結。若使用一般的 email 認證方式，可以忽略此欄位。',
    'users_password_warning' => '如果您想更改此用戶的密碼，請填寫以下內容：',
    'users_system_public' => '此使用者代表造訪您站台的任何訪客使用者。其不能用於登入，而會自動分配。',
    'users_delete' => '刪除使用者',
    'users_delete_named' => '刪除使用者 :userName',
    'users_delete_warning' => '這將從系統中完全刪除名為「:userName」的使用者。',
    'users_delete_confirm' => '您確定要刪除此使用者？',
    'users_migrate_ownership' => '轉移所有權',
    'users_migrate_ownership_desc' => '如果您希望其他使用者變成目前此使用者擁有的所有項目的新擁有者，請在此處選取新的使用者。',
    'users_none_selected' => '未選取使用者',
    'users_edit' => '編輯使用者',
    'users_edit_profile' => '編輯個人資料',
    'users_avatar' => '使用者大頭照',
    'users_avatar_desc' => '選取一張代表此使用者的圖片。這應該是大約 256px 的正方形。',
    'users_preferred_language' => '偏好語言',
    'users_preferred_language_desc' => '此選項將會變更用於應用程式使用者介面的語言。不會影響任何使用者建立的內容。',
    'users_social_accounts' => '社群網站帳號',
    'users_social_accounts_desc' => '查看此用戶已連接的社交賬戶狀態。 除了主要認證系統外，社交賬戶也可用於系統訪問。',
    'users_social_accounts_info' => '您可以在此處連結您其他的帳號以供快速登入。從此處取消連結帳號並不會撤銷先前已授權的存取。請從您連結的社群網站帳號的個人設定中撤銷存取權。',
    'users_social_connect' => '連結帳號',
    'users_social_disconnect' => '取消連結帳號',
    'users_social_status_connected' => '已連接',
    'users_social_status_disconnected' => '已斷開連接',
    'users_social_connected' => ':socialAccount 帳號已經成功連結到您的個人資料。',
    'users_social_disconnected' => ':socialAccount 帳號已經成功取消連結。',
    'users_api_tokens' => 'API 權杖',
    'users_api_tokens_desc' => '創建和管理用於 BookStack REST API 認證的訪問令牌。 API 的權限是通過令牌所屬的用戶管理的。',
    'users_api_tokens_none' => '尚未為此使用者建立 API 權杖',
    'users_api_tokens_create' => '建立權杖',
    'users_api_tokens_expires' => '過期',
    'users_api_tokens_docs' => 'API 文件',
    'users_mfa' => '多重身分驗證',
    'users_mfa_desc' => '設定多重身份驗證為您的帳戶多增加了一道防線',
    'users_mfa_x_methods' => ':count 個措施已配置|:count 個措施已配置',
    'users_mfa_configure' => '方式設置',

    // API Tokens
    'user_api_token_create' => '建立 API 權杖',
    'user_api_token_name' => '名稱',
    'user_api_token_name_desc' => '給您的權杖易於辨識的名稱，如此未來才能提醒其預期用途。',
    'user_api_token_expiry' => '到期日',
    'user_api_token_expiry_desc' => '設定此權杖的到期日。在此日期後，使用此權杖發出的請求將不再起作用。若將此欄留空，將會設定在100年後過期。',
    'user_api_token_create_secret_message' => '建立此權杖後，將會立即生成並顯示「權杖 ID」與「權杖密碼」。該密碼將只會顯示一次，因此請在繼續操作前將其複製到安全的地方。',
    'user_api_token' => 'API 權杖',
    'user_api_token_id' => '權杖 ID',
    'user_api_token_id_desc' => '這是此權杖由系統生成的不可編輯識別字串，必須在 API 請求中提供。',
    'user_api_token_secret' => '權杖密碼',
    'user_api_token_secret_desc' => '這是此權杖由系統生成的密碼，必須在 API 請求中提供。該密碼將只會顯示一次，因此請在繼續操作前將其複製到安全的地方。',
    'user_api_token_created' => '權杖建立於:timeAgo',
    'user_api_token_updated' => '權杖更新於:timeAgo',
    'user_api_token_delete' => '刪除權杖',
    'user_api_token_delete_warning' => '這將會從系統中完全刪除名為「:tokenName」的 API 權杖。',
    'user_api_token_delete_confirm' => '您確定要刪除此 API 權杖嗎？',

    // Webhooks
    'webhooks' => 'Webhooks',
    'webhooks_index_desc' => 'Webhook 是一種在系統內發生某些操作和事件時將數據發送到外部 URL 的方法，它允許與外部平台（例如消息傳遞或通知系統）進行基於事件的集成。',
    'webhooks_x_trigger_events' => ':count 個觸發事件 |:count 個觸發事件',
    'webhooks_create' => '建立 Webhook',
    'webhooks_none_created' => '沒有已建立的 Webhook',
    'webhooks_edit' => '設置 Webhook',
    'webhooks_save' => '儲存 Webhook',
    'webhooks_details' => 'WebHook 詳細資料',
    'webhooks_details_desc' => '提供一個用戶友好的名稱和一個 POST Endpoint 作為 Webhook 數據發送的位置。',
    'webhooks_events' => 'Webhook 事件',
    'webhooks_events_desc' => '選擇所有應觸發此 Webhook 的事件。',
    'webhooks_events_warning' => '請記住，即使應用了自定義權限，所有選定的事件也仍然會被觸發。 確保使用此 Webhook 不會洩露機密內容。',
    'webhooks_events_all' => '全部系統活動',
    'webhooks_name' => 'Webhook 名稱',
    'webhooks_timeout' => 'Webhook 請求超時（秒）',
    'webhooks_endpoint' => 'Webhook 端點',
    'webhooks_active' => 'Webhook 啟用',
    'webhook_events_table_header' => '事件',
    'webhooks_delete' => '刪除 Webhook',
    'webhooks_delete_warning' => '這將會從系統中完全刪除名為 “:webhookName” 的 webhook。',
    'webhooks_delete_confirm' => '確定要刪除此 Webhook 嗎？',
    'webhooks_format_example' => 'Webhook 格式範例',
    'webhooks_format_example_desc' => 'Webhook 數據會以 POST 請求按照以下 JSON 格式發送到設置的 Endpoint。 “related_item” 和 “url” 屬性是可選的，取決於觸發的事件類型。',
    'webhooks_status' => 'Webhook 狀態',
    'webhooks_last_called' => '最後一次調用：',
    'webhooks_last_errored' => '上次錯誤',
    'webhooks_last_error_message' => '上次錯誤信息',

    // Licensing
    'licenses' => '授權',
    'licenses_desc' => '本頁提供 BookStack 使用到的專案以及函式庫的詳細授權資料，其中部份專案及函式庫僅開開發環境中使用。',
    'licenses_bookstack' => 'BookStack 授權',
    'licenses_php' => 'PHP 函式庫授權',
    'licenses_js' => 'JavaScript 函式庫授權',
    'licenses_other' => '其它授權',
    'license_details' => '詳細授權資料',

    //! If editing translations files directly please ignore this in all
    //! languages apart from en. Content will be auto-copied from en.
    //!////////////////////////////////
    'language_select' => [
        'en' => 'English',
        'ar' => 'العربية',
        'bg' => 'Bǎlgarski',
        'bs' => 'Bosanski',
        'ca' => '加泰隆尼亞語',
        'cs' => 'Česky',
        'cy' => 'Cymraeg',
        'da' => '丹麥',
        'de' => 'Deutsch (Sie)',
        'de_informal' => 'Deutsch (Du)',
        'el' => 'ελληνικά',
        'es' => 'Español',
        'es_AR' => 'Español Argentina',
        'et' => 'Eesti keel',
        'eu' => 'Euskara',
        'fa' => 'فارسی',
        'fi' => 'Suomi',
        'fr' => 'Français',
        'he' => '希伯來語',
        'hr' => 'Hrvatski',
        'hu' => 'Magyar',
        'id' => 'Bahasa Indonesia',
        'it' => 'Italian',
        'ja' => '日本語',
        'ko' => '한국어',
        'lt' => 'Lietuvių Kalba',
        'lv' => 'Latviešu Valoda',
        'nb' => 'Norsk (Bokmål)',
        'ne' => 'नेपाली',
        'nn' => 'Nynorsk',
        'nl' => 'Nederlands',
        'pl' => 'Polski',
        'pt' => 'Português',
        'pt_BR' => 'Português do Brasil',
        'ro' => 'Română',
        'ru' => 'Русский',
        'sk' => 'Slovensky',
        'sl' => 'Slovenščina',
        'sv' => 'Svenska',
        'tr' => 'Türkçe',
        'uk' => 'Українська',
        'uz' => 'O‘zbekcha',
        'vi' => 'Tiếng Việt',
        'zh_CN' => '简体中文',
        'zh_TW' => '繁體中文',
    ],
    //!////////////////////////////////
];
